/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.cec;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIFeatureCodeLookup;
import com.ibm.hsc.fsp.cmdhelpers.FspIoBus;
import com.ibm.hsc.fsp.cmdhelpers.FspIoSlot;
import com.ibm.hsc.fsp.cmdhelpers.FspIoSlotCommon;
import com.ibm.hsc.fsp.cmdhelpers.FspIoSlotVpd;
import com.ibm.hsc.fsp.cmdhelpers.FspIoUnit;
import com.ibm.hsc.lock.Lock;
import com.ibm.hsc.objmgr.OmUtils;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import com.ibm.hsc.rep.v50.R50Define;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class OmIoResAct {
    private OmCecMgr mCecMgr = null;

    public OmIoResAct(OmCecMgr omCecMgr) {
        this.mCecMgr = omCecMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildDrawer(RObject rObject, UnsignedInt16[] unsignedInt16Array) throws RException, PIHscServerException, PIHscCmdMgrException {
        String string = (String)rObject.getProperty("Name");
        if (string == null || string.equals("")) {
            System.out.println("Error in rebuildDrawer - drawerName is not available: " + string);
            throw new PIHscServerException("01FF", null);
        }
        Lock lock = Lock.getInstance("root/ibmhscS1_0", string);
        try {
            System.out.println("rebuildDrawer - try to lock drawer: " + string);
            lock.lock(1);
            this.rebuildDrawer0(rObject, unsignedInt16Array);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private void rebuildDrawer0(RObject rObject, UnsignedInt16[] unsignedInt16Array) throws RException, PIHscServerException, PIHscCmdMgrException {
        FspIoUnit fspIoUnit = null;
        File file = new File("/opt/hsc/data/phyp440");
        if (file.exists()) {
            String string = (String)rObject.getProperty("Type");
            String string2 = (String)rObject.getProperty("Model");
            String string3 = (String)rObject.getProperty("SerialNum");
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)rObject.getProperty("UnitID");
            fspIoUnit = this.mCecMgr.getCmdHelper().getIoUnitInfo(string, string2, string3, unsignedInt16);
            rObject.setProperty("LocationCode", (Object)fspIoUnit.getLocationCode());
            rObject.setProperty("SpcnId", (Object)fspIoUnit.getSpcnId());
        } else {
            String string = (String)rObject.getProperty("Name");
            String string4 = OmUtils.getInstance().getFirstName(string);
            fspIoUnit = this.mCecMgr.getCmdHelper().getIoInfo(string4);
        }
        if (fspIoUnit == null) {
            this.deleteDrawer0(rObject);
            return;
        }
        this.rebuildBuses(fspIoUnit.getBusIds(), rObject, unsignedInt16Array);
        this.clearEmptyIopGroup(rObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDrawer(RObject rObject) throws PIHscServerException, RException {
        String string = (String)rObject.getProperty("Name");
        if (string == null || string.equals("")) {
            System.out.println("Error in deleteDrawer: drawerName is not available: " + string);
            throw new PIHscServerException("01FF", null);
        }
        Lock lock = Lock.getInstance("root/ibmhscS1_0", string);
        try {
            System.out.println("deleteDrawer - try to lock drawer: " + string);
            lock.lock(1);
            this.deleteDrawer0(rObject);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private void deleteDrawer0(RObject rObject) throws RException {
        RObjectId rObjectId = rObject.getObjectId();
        if (rObjectId.getObject() == null) {
            System.out.println("Drawer not found in repository: " + rObjectId);
            return;
        }
        Vector vector = rObject.associators(R50Define.AID_IBMHSC_IODrawerPCIBus);
        RObject rObject2 = null;
        if (vector != null && !vector.isEmpty()) {
            for (int i = 0; i < vector.size(); ++i) {
                rObject2 = (RObject)vector.elementAt(i);
                this.deleteBus(rObject2);
            }
        }
        rObject.deleteAssociated(R50Define.AID_IBMHSC_IODrawerIOPGroup);
        rObject.deleteInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RObject createDrawerByMtms(String string, String string2, String string3, UnsignedInt16 unsignedInt16, UnsignedInt16[] unsignedInt16Array) throws RException, PIHscServerException, PIHscCmdMgrException {
        FspIoUnit fspIoUnit = this.mCecMgr.getCmdHelper().getIoUnitInfo(string, string2, string3, unsignedInt16);
        System.out.println("unitInfo = " + fspIoUnit);
        if (fspIoUnit == null) {
            return null;
        }
        String string4 = fspIoUnit.getType();
        String string5 = fspIoUnit.getModel();
        String string6 = fspIoUnit.getSerial();
        if (string4 == null || string4.length() < 1) {
            string4 = (String)this.mCecMgr.getProperty("PlatformType");
            System.out.println("ERROR!!!!   NULL TYPE:  Updated unit type = " + string4);
        }
        if (string6 == null || string6.length() < 1) {
            string6 = (String)this.mCecMgr.getProperty("PlatformSerial");
            System.out.println("ERROR!!!!   NULL SERIAL: Updated unit serial = " + string6);
        }
        RObject rObject = new RObject(1, R50Define.CID_IBMHSC_IODrawer);
        String string7 = OmUtils.getInstance().getMtms(string4, string5, string6);
        if (string7 == null || string7.equals("")) {
            System.out.println("Error in createDrawerByMtms - drawerName is not available: " + string7);
            throw new PIHscServerException("01FF", null);
        }
        Lock lock = Lock.getInstance("root/ibmhscS1_0", string7);
        try {
            System.out.println("createDrawerByMtms - try to lock drawer: " + string7);
            lock.lock(1);
            string7 = fspIoUnit.getUnitId() + "*" + string7;
            rObject.setProperty("Name", (Object)string7);
            rObject.setProperty("Type", (Object)string4);
            rObject.setProperty("Model", (Object)string5);
            rObject.setProperty("SerialNum", (Object)string6);
            rObject.setProperty("UnitID", (Object)unsignedInt16);
            rObject.setProperty("CreationClassName", (Object)"IBMHSC_IODrawer");
            rObject.setProperty("LocationCode", (Object)fspIoUnit.getLocationCode());
            rObject.setProperty("SpcnId", (Object)fspIoUnit.getSpcnId());
            try {
                rObject.addInstance();
            }
            catch (RException rException) {
                rException.printStackTrace();
                if (rException.getID().equals("R_ERR_ALREADY_EXISTS")) {
                    System.out.println("Drawer: " + string7 + " already exists. Exp ignored...");
                }
                throw rException;
            }
            if (!rObject.hasAssociation(R50Define.AID_IBMHSC_UsingIODrawer, this.mCecMgr.getObjectId())) {
                rObject.addAssociation(R50Define.AID_IBMHSC_UsingIODrawer, this.mCecMgr.getObjectId());
            }
            this.rebuildBuses(fspIoUnit.getBusIds(), rObject, unsignedInt16Array);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return rObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RObject createDrawerByLocCode(String string, UnsignedInt16[] unsignedInt16Array) throws RException, PIHscServerException, PIHscCmdMgrException {
        FspIoUnit fspIoUnit = this.mCecMgr.getCmdHelper().getIoInfo(string);
        System.out.println("unitInfo = " + fspIoUnit);
        if (fspIoUnit == null) {
            return null;
        }
        if (string == null || string.equals("")) {
            System.out.println("Error in createDrawerByLocCode - locationCode is not available: " + string);
            throw new PIHscServerException("01FF", null);
        }
        RObject rObject = new RObject(1, R50Define.CID_IBMHSC_IODrawer);
        String string2 = OmUtils.getInstance().makeFullName(string, this.mCecMgr.getCecName());
        Lock lock = Lock.getInstance("root/ibmhscS1_0", string2);
        try {
            System.out.println("createDrawerByLocCode - try to lock drawer: " + string2);
            lock.lock(1);
            rObject.setProperty("Name", (Object)string2);
            rObject.setProperty("CreationClassName", (Object)"IBMHSC_IODrawer");
            rObject.setProperty("LocationCode", (Object)fspIoUnit.getLocationCode());
            try {
                rObject.addInstance();
            }
            catch (RException rException) {
                if (rException.getID().equals("R_ERR_ALREADY_EXISTS")) {
                    System.out.println("Drawer:" + string2 + " already exists. Exp ignored...");
                }
                rException.printStackTrace();
                throw rException;
            }
            if (!rObject.hasAssociation(R50Define.AID_IBMHSC_UsingIODrawer, this.mCecMgr.getObjectId())) {
                rObject.addAssociation(R50Define.AID_IBMHSC_UsingIODrawer, this.mCecMgr.getObjectId());
            }
            this.rebuildBuses(fspIoUnit.getBusIds(), rObject, unsignedInt16Array);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return rObject;
    }

    public void updateIoDrawers() throws RException, PIHscServerException, PIHscCmdMgrException {
        File file = new File("/opt/hsc/data/phyp440");
        boolean bl = false;
        if (file.exists()) {
            bl = true;
        }
        UnsignedInt16[] unsignedInt16Array = null;
        try {
            unsignedInt16Array = this.mCecMgr.getCmdHelper().getAllIoBusIds();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (unsignedInt16Array != null) {
            System.out.println("allBusIds.length: " + unsignedInt16Array.length);
            if (unsignedInt16Array != null) {
                for (int i = 0; i < unsignedInt16Array.length; ++i) {
                    System.out.println("allBusIds[" + i + "] = " + unsignedInt16Array[i]);
                }
            }
        } else {
            System.out.println("allBusIds is null");
        }
        boolean bl2 = false;
        System.out.println("Try to get all IO drawers");
        FspIoUnit[] fspIoUnitArray = this.mCecMgr.getCmdHelper().getAllIoUnitIds();
        UnsignedInt16[] unsignedInt16Array2 = new UnsignedInt16[]{};
        String[] stringArray = new String[]{};
        if (fspIoUnitArray != null) {
            int n;
            System.out.println("ioUnitList.length: " + fspIoUnitArray.length);
            if (bl) {
                unsignedInt16Array2 = new UnsignedInt16[fspIoUnitArray.length];
                for (n = 0; n < fspIoUnitArray.length; ++n) {
                    unsignedInt16Array2[n] = fspIoUnitArray[n].getUnitId();
                    System.out.println("drawer[" + n + "]'s mtms :" + unsignedInt16Array2[n]);
                }
            } else {
                stringArray = new String[fspIoUnitArray.length];
                for (n = 0; n < fspIoUnitArray.length; ++n) {
                    stringArray[n] = fspIoUnitArray[n].getLocationCode();
                    System.out.println("drawer[" + n + "]'s location code: " + stringArray[n]);
                }
            }
        } else {
            System.out.println("ioUnitList is null");
        }
        Vector vector = this.mCecMgr.getObject().associators(R50Define.AID_IBMHSC_UsingIODrawer);
        System.out.println("drawerInsts = " + vector);
        if (vector != null && !vector.isEmpty()) {
            RObject rObject = null;
            System.out.println("drawerInsts.size(): " + vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                Object object;
                rObject = (RObject)vector.elementAt(i);
                int n = -1;
                if (bl) {
                    object = (UnsignedInt16)rObject.getProperty("UnitID");
                    System.out.println("drawer unit id is: " + object);
                    for (int j = 0; j < unsignedInt16Array2.length; ++j) {
                        System.out.println("mtmsList[" + j + "]: " + unsignedInt16Array2[j]);
                        if (unsignedInt16Array2[j] == null || !unsignedInt16Array2[j].equals(object)) continue;
                        n = j;
                        break;
                    }
                } else {
                    object = (String)rObject.getProperty("Name");
                    String string = OmUtils.getInstance().getFirstName((String)object);
                    System.out.println("drawer unit id is: " + string);
                    for (int j = 0; j < stringArray.length; ++j) {
                        System.out.println("locCodeList[" + j + "]: " + stringArray[j]);
                        if (stringArray[j] == null || !stringArray[j].equals(string)) continue;
                        n = j;
                        break;
                    }
                }
                if (n == -1) {
                    this.deleteDrawer(rObject);
                    continue;
                }
                this.rebuildDrawer(rObject, unsignedInt16Array);
                if (bl) {
                    unsignedInt16Array2[n] = null;
                    continue;
                }
                stringArray[n] = null;
            }
        }
        if (bl) {
            for (int i = 0; i < unsignedInt16Array2.length; ++i) {
                if (unsignedInt16Array2[i] == null) continue;
                this.createDrawerByMtms(fspIoUnitArray[i].getType(), fspIoUnitArray[i].getModel(), fspIoUnitArray[i].getSerial(), fspIoUnitArray[i].getUnitId(), unsignedInt16Array);
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                this.createDrawerByLocCode(fspIoUnitArray[i].getLocationCode(), unsignedInt16Array);
            }
        }
        System.out.println("handling stale buses");
        this.clearEmptyFailedOverPool();
    }

    public void ioDrawerChanged(String string, String string2, String string3) throws RException, PIHscServerException, PIHscCmdMgrException {
        String string4 = OmUtils.getInstance().getMtms(string, string2, string3);
        RObject rObject = this.getDrawerInstByMtms(string4);
        if (rObject == null) {
            this.createDrawerByMtms(string, string2, string3, new UnsignedInt16(0), null);
            return;
        }
        this.rebuildDrawer(rObject, null);
        this.clearEmptyFailedOverPool();
    }

    public void ioDrawerChanged(String string) throws RException, PIHscServerException, PIHscCmdMgrException {
        RObject rObject = this.getDrawerInstByMtms(string);
        if (rObject == null) {
            this.createDrawerByLocCode(string, null);
            return;
        }
        this.rebuildDrawer(rObject, null);
        this.clearEmptyFailedOverPool();
    }

    private RObject getDrawerInstByMtms(String string) throws RException {
        RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_IODrawer);
        rObjectId.setKeyValue(0, string);
        rObjectId.setKeyValue(1, "IBMHSC_IODrawer");
        RObject rObject = rObjectId.getObject();
        return rObject;
    }

    private void deleteBus(RObject rObject) throws RException {
        Vector vector = rObject.associators(R50Define.AID_IBMHSC_SlotInBus);
        RObject rObject2 = null;
        Hashtable hashtable = this.mCecMgr.getPhyIODrcIndexTable();
        Hashtable hashtable2 = this.mCecMgr.getPhyIODrcNameTable();
        Hashtable hashtable3 = this.mCecMgr.getPhyIODrcIndexToFullLocTable();
        if (vector != null && !vector.isEmpty()) {
            for (int i = 0; i < vector.size(); ++i) {
                rObject2 = (RObject)vector.elementAt(i);
                hashtable.remove(rObject2.getProperty("DeviceID"));
                hashtable2.remove(rObject2.getProperty("DrcName"));
                hashtable3.remove(rObject2.getProperty("DeviceID"));
            }
        }
        rObject.deleteAssociated(R50Define.AID_IBMHSC_SlotInBus);
        rObject.deleteInstance();
    }

    private RObject createBusById(UnsignedInt16 unsignedInt16, RObject rObject, FspIoBus fspIoBus) throws RException, PIHscServerException, PIHscCmdMgrException {
        System.out.println("++++++++ new io bus id: " + unsignedInt16);
        System.out.println("busInfo = " + fspIoBus);
        RObject rObject2 = new RObject(1, R50Define.CID_IBMHSC_PCIBus);
        rObject2.setProperty("DeviceID", (Object)unsignedInt16.toString());
        rObject2.setProperty("LocationCode", (Object)fspIoBus.getLocationCode());
        rObject2.setProperty("SystemCreationClassName", (Object)"IBMHSC_IODrawer");
        rObject2.setProperty("CreationClassName", (Object)"IBMHSC_PCIBus");
        rObject2.setProperty("SystemName", rObject.getProperty("Name"));
        rObject2.setProperty("DrcIndex", (Object)fspIoBus.getDrcIndex());
        rObject2.setProperty("DrcName", (Object)fspIoBus.getDrcName());
        rObject2.addInstance();
        rObject2.addAssociation(R50Define.AID_IBMHSC_IODrawerPCIBus, rObject.getObjectId());
        this.rebuildSlots(fspIoBus, rObject, rObject2);
        return rObject2;
    }

    private void rebuildBusInst(RObject rObject, RObject rObject2, FspIoBus fspIoBus) throws RException, PIHscServerException, PIHscCmdMgrException {
        String string = (String)rObject.getProperty("DeviceID");
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(string);
        if (rObject.setProperty("LocationCode", (Object)fspIoBus.getLocationCode())) {
            System.out.println("++++++++LocationCode updated: " + fspIoBus.getLocationCode());
        }
        this.rebuildSlots(fspIoBus, rObject2, rObject);
    }

    private void rebuildBuses(UnsignedInt16[] unsignedInt16Array, RObject rObject, UnsignedInt16[] unsignedInt16Array2) throws RException, PIHscServerException, PIHscCmdMgrException {
        try {
            Object object;
            int n;
            boolean bl = false;
            Vector vector = rObject.associators(R50Define.AID_IBMHSC_IODrawerPCIBus);
            System.out.println("busInsts = " + vector);
            RObject rObject2 = null;
            if (vector != null && !vector.isEmpty()) {
                for (n = 0; n < vector.size(); ++n) {
                    rObject2 = (RObject)vector.elementAt(n);
                    object = (String)rObject2.getProperty("DeviceID");
                    UnsignedInt16 unsignedInt16 = new UnsignedInt16((String)object);
                    int n2 = -1;
                    for (int i = 0; i < unsignedInt16Array.length; ++i) {
                        if (unsignedInt16Array[i] == null || !unsignedInt16.equals((Object)unsignedInt16Array[i])) continue;
                        n2 = i;
                        break;
                    }
                    if (n2 == -1) {
                        if (rObject != null) {
                            System.out.println("bus id " + unsignedInt16 + " not exist in PHYP and drawer is not null, delete the repo inst");
                            this.deleteBus(rObject2);
                            continue;
                        }
                        System.out.println("ERROR: bus id " + unsignedInt16 + " not exist in PHYP, and drawer is null");
                        continue;
                    }
                    FspIoBus fspIoBus = this.mCecMgr.getCmdHelper().getIoBusInfo(unsignedInt16);
                    System.out.println("busInfo = " + fspIoBus);
                    if (fspIoBus == null) {
                        this.deleteBus(rObject2);
                        continue;
                    }
                    this.setNotStale(unsignedInt16Array2, unsignedInt16);
                    this.rebuildBusInst(rObject2, rObject, fspIoBus);
                    unsignedInt16Array[n2] = null;
                }
            }
            for (n = 0; n < unsignedInt16Array.length; ++n) {
                if (unsignedInt16Array[n] == null) continue;
                System.out.println("++++++++ new io bus id: " + unsignedInt16Array[n]);
                object = this.mCecMgr.getCmdHelper().getIoBusInfo(unsignedInt16Array[n]);
                System.out.println("busInfo = " + object);
                if (object == null) continue;
                this.setNotStale(unsignedInt16Array2, unsignedInt16Array[n]);
                this.createBusById(unsignedInt16Array[n], rObject, (FspIoBus)object);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
        }
    }

    private void setNotStale(UnsignedInt16[] unsignedInt16Array, UnsignedInt16 unsignedInt16) {
        System.out.println("calling setNotStale: " + unsignedInt16);
        if (unsignedInt16Array == null || unsignedInt16Array.length < 1) {
            return;
        }
        for (int i = 0; i < unsignedInt16Array.length; ++i) {
            if (unsignedInt16Array[i] == null || !unsignedInt16Array[i].equals((Object)unsignedInt16)) continue;
            System.out.println("found bus " + unsignedInt16Array[i] + " set it to null");
            unsignedInt16Array[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void busesChanged(Vector vector) throws RException, PIHscServerException, PIHscCmdMgrException {
        int n = 0;
        while (true) {
            block16: {
                Object var14_13;
                Lock lock;
                String string;
                block19: {
                    block18: {
                        block17: {
                            if (n >= vector.size()) {
                                this.clearEmptyFailedOverPool();
                                return;
                            }
                            Integer n2 = (Integer)vector.elementAt(n);
                            UnsignedInt16 unsignedInt16 = new UnsignedInt16(n2 & Integer.MAX_VALUE);
                            boolean bl = (n2 & Integer.MIN_VALUE) != 0;
                            System.out.println("bus id: " + unsignedInt16 + " onlyChangeCommonInfo: " + bl);
                            RObject[] rObjectArray = this.getBusDrawerInstByBusId(unsignedInt16);
                            if (rObjectArray == null) {
                                System.out.println("cannot find drawer and bus in REP rebuild all IO drawers");
                                this.updateIoDrawers();
                                this.rebuildSlotsCommon();
                                return;
                            }
                            RObject rObject = rObjectArray[0];
                            RObject rObject2 = rObjectArray[1];
                            string = (String)rObject2.getProperty("Name");
                            if (string == null || string.equals("")) {
                                System.out.println("Error in busesChanged - drawerName is not available: " + string);
                                throw new PIHscServerException("01FF", null);
                            }
                            lock = Lock.getInstance("root/ibmhscS1_0", string);
                            try {
                                System.out.println("busesChanged - try to lock drawer: " + string);
                                lock.lock(1);
                                RObjectId rObjectId = rObject2.getObjectId();
                                if (rObjectId.getObject() == null) {
                                    System.out.println("busesChanged - drawer not found: " + rObjectId);
                                    var14_13 = null;
                                    if (lock == null) break block16;
                                    break block17;
                                }
                                if (!bl) {
                                    FspIoBus fspIoBus = this.mCecMgr.getCmdHelper().getIoBusInfo(unsignedInt16);
                                    if (fspIoBus == null) {
                                        this.deleteBusByBusId(unsignedInt16);
                                        break block18;
                                    }
                                    if (rObject != null) {
                                        this.rebuildBusInst(rObject, rObject2, fspIoBus);
                                    } else {
                                        rObject = this.createBusById(unsignedInt16, rObject2, fspIoBus);
                                    }
                                }
                                if (rObject != null) {
                                    this.rebuildSlotsCommonForBus(rObject, false);
                                    break block19;
                                } else {
                                    System.out.println("cannot create bus inst for bus id: " + unsignedInt16);
                                }
                                break block19;
                            }
                            catch (Throwable throwable) {
                                var14_13 = null;
                                if (lock != null) {
                                    lock.unlock();
                                    System.out.println("busesChanged - unlock drawer: " + string);
                                }
                                throw throwable;
                            }
                        }
                        lock.unlock();
                        System.out.println("busesChanged - unlock drawer: " + string);
                        break block16;
                    }
                    var14_13 = null;
                    if (lock != null) {
                        lock.unlock();
                        System.out.println("busesChanged - unlock drawer: " + string);
                    }
                    break block16;
                }
                var14_13 = null;
                if (lock != null) {
                    lock.unlock();
                    System.out.println("busesChanged - unlock drawer: " + string);
                }
            }
            ++n;
        }
    }

    private RObject getBusInstByBusId(UnsignedInt16 unsignedInt16, String string) throws RException {
        RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_PCIBus);
        rObjectId.setKeyValue(0, "IBMHSC_IODrawer");
        rObjectId.setKeyValue(1, string);
        rObjectId.setKeyValue(2, "IBMHSC_PCIBus");
        rObjectId.setKeyValue(3, unsignedInt16);
        return rObjectId.getObject();
    }

    private void deleteBusByBusId(UnsignedInt16 unsignedInt16) throws RException {
        RObject[] rObjectArray = this.getBusDrawerInstByBusId(unsignedInt16);
        this.deleteBus(rObjectArray[0]);
        this.clearEmptyIopGroup(rObjectArray[1]);
    }

    private RObject[] getBusDrawerInstByBusId(UnsignedInt16 unsignedInt16) throws RException {
        Vector vector = this.mCecMgr.getObject().associators(R50Define.AID_IBMHSC_UsingIODrawer);
        if (vector == null || vector.size() == 0) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            RObject rObject = (RObject)vector.elementAt(i);
            Vector vector2 = rObject.associators(R50Define.AID_IBMHSC_IODrawerPCIBus);
            if (vector2 == null || vector2.size() == 0) continue;
            for (int j = 0; j < vector2.size(); ++j) {
                RObject rObject2 = (RObject)vector2.elementAt(j);
                String string = (String)rObject2.getProperty("DeviceID");
                if (!unsignedInt16.toString().equals(string)) continue;
                RObject[] rObjectArray = new RObject[]{rObject2, rObject};
                return rObjectArray;
            }
        }
        return null;
    }

    private void createSlotInst(FspIoSlot fspIoSlot, FspIoSlotVpd fspIoSlotVpd, RObject rObject, RObject rObject2) throws RException {
        RObject rObject3 = new RObject(1, R50Define.CID_IBMHSC_PCISlot);
        rObject3.setProperty("DeviceID", (Object)("" + fspIoSlot.getDrcIndex()));
        rObject3.setProperty("SystemCreationClassName", (Object)"IBMHSC_IODrawer");
        rObject3.setProperty("SystemName", rObject.getProperty("Name"));
        rObject3.setProperty("CreationClassName", (Object)"IBMHSC_PCISlot");
        rObject3.addInstance();
        Hashtable hashtable = this.mCecMgr.getPhyIODrcIndexTable();
        Hashtable hashtable2 = this.mCecMgr.getPhyIODrcNameTable();
        Hashtable hashtable3 = this.mCecMgr.getPhyIODrcIndexToFullLocTable();
        hashtable.put(fspIoSlot.getDrcIndex(), fspIoSlot.getDrcName());
        hashtable2.put(fspIoSlot.getDrcName(), fspIoSlot.getDrcIndex());
        hashtable3.put(fspIoSlot.getDrcIndex(), rObject3.getProperty("SystemName") + " " + fspIoSlot.getLocationCode());
        this.rebuildSlotInst(rObject3, fspIoSlot, fspIoSlotVpd, rObject, rObject2);
    }

    private void rebuildSlotInst(RObject rObject, FspIoSlot fspIoSlot, FspIoSlotVpd fspIoSlotVpd, RObject rObject2, RObject rObject3) throws RException {
        UnsignedInt16 unsignedInt16 = fspIoSlot.getClassCode();
        UnsignedInt16 unsignedInt162 = fspIoSlot.getVendorId();
        UnsignedInt16 unsignedInt163 = fspIoSlot.getDeviceId();
        UnsignedInt16 unsignedInt164 = fspIoSlot.getSubsystemVendorId();
        UnsignedInt16 unsignedInt165 = fspIoSlot.getSubsystemDeviceId();
        UnsignedInt8 unsignedInt8 = fspIoSlot.getRevisionId();
        if (rObject.setProperty("SlotLocation", (Object)fspIoSlot.getLocationCode())) {
            System.out.println("++++++++ SlotLocation updated: " + fspIoSlot.getLocationCode());
        }
        if (rObject.setProperty("PCIClassCode", (Object)unsignedInt16)) {
            System.out.println("++++++++ classCode updated: " + unsignedInt16);
        }
        if (rObject.setProperty("VendorID", (Object)unsignedInt162)) {
            System.out.println("++++++++ VendorID updated: " + unsignedInt162);
        }
        if (rObject.setProperty("PCIDeviceID", (Object)unsignedInt163)) {
            System.out.println("++++++++ pciDeviceID updated: " + unsignedInt163);
        }
        if (rObject.setProperty("SubsystemVendorID", (Object)unsignedInt164)) {
            System.out.println("++++++++ subVendorID updated: " + unsignedInt164);
        }
        if (rObject.setProperty("SubsystemDeviceID", (Object)unsignedInt165)) {
            System.out.println("++++++++ subDeviceID updated: " + unsignedInt165);
        }
        if (rObject.setProperty("RevisionID", (Object)unsignedInt8)) {
            System.out.println("++++++++ RevisionID updated: " + unsignedInt8);
        }
        System.out.println("in ommgr busgrouping " + fspIoSlot.getBusGrouping());
        if (rObject.setProperty("BusGrouping", (Object)fspIoSlot.getBusGrouping())) {
            System.out.println("++++++++ busGrouping updated: " + fspIoSlot.getBusGrouping());
        }
        if (rObject.setProperty("HasOS400VPD", (Object)fspIoSlot.getHasOs400Vpd())) {
            System.out.println("++++++++ hasOS400VPD updated: " + fspIoSlot.getHasOs400Vpd());
        }
        if (rObject.setProperty("IOPInfo", (Object)fspIoSlot.getIopInfo())) {
            System.out.println("++++++++ iopInfo updated: " + fspIoSlot.getIopInfo());
        }
        if (rObject.setProperty("VPDModel", (Object)fspIoSlotVpd.getModel())) {
            System.out.println("++++++++ VPDModel updated: " + fspIoSlotVpd.getModel());
        }
        if (rObject.setProperty("VPDType", (Object)fspIoSlotVpd.getType())) {
            System.out.println("++++++++ VPDType updated: " + fspIoSlotVpd.getType());
        }
        if (rObject.setProperty("VPDSerialNum", (Object)fspIoSlotVpd.getSerial())) {
            System.out.println("++++++++ VPDSerialNum updated: " + fspIoSlotVpd.getSerial());
        }
        if (rObject.setProperty("DrcName", (Object)fspIoSlot.getDrcName())) {
            System.out.println("++++++++ DrcName updated: " + fspIoSlot.getDrcName());
        }
        if (rObject.setProperty("FieldFormat", (Object)fspIoSlot.getFieldFormat())) {
            System.out.println("++++++++ FieldFormat updated: " + fspIoSlot.getFieldFormat());
        }
        this.rebuildSlotAssociations(rObject, rObject2, fspIoSlot, rObject3);
        PIFeatureCodeLookup pIFeatureCodeLookup = PIFeatureCodeLookup.getInstance();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        RObject rObject4 = this.mCecMgr.getObject();
        UnsignedInt16 unsignedInt166 = (UnsignedInt16)rObject4.getProperty(R50ComputerSystem.Index_Brand);
        pIFeatureCodeLookup.lookupFeatureCode(unsignedInt166, unsignedInt162.intValue(), unsignedInt163.intValue(), unsignedInt164.intValue(), unsignedInt165.intValue(), unsignedInt16.intValue(), unsignedInt8.intValue(), arrayList, arrayList2, arrayList3);
        Vector vector = null;
        if (arrayList.size() != 0) {
            vector = new Vector(arrayList);
        }
        if (rObject.setProperty("FeatureCodesO", vector)) {
            System.out.println("++++++++ FeatureCodesO updated: " + vector);
        }
        Vector vector2 = null;
        if (arrayList2.size() != 0) {
            vector2 = new Vector(arrayList2);
        }
        if (rObject.setProperty("FeatureCodesL", vector2)) {
            System.out.println("++++++++ FeatureCodesL updated: " + vector2);
        }
        Vector vector3 = null;
        if (arrayList3.size() != 0) {
            vector3 = new Vector(arrayList3);
        }
        if (rObject.setProperty("FeatureCodesA", vector3)) {
            System.out.println("++++++++ FeatureCodesA updated: " + vector3);
        }
    }

    private void rebuildSlots(FspIoBus fspIoBus, RObject rObject, RObject rObject2) throws RException {
        try {
            int n;
            FspIoSlot[] fspIoSlotArray = this.mCecMgr.getCmdHelper().getIoSlotsInfo(fspIoBus);
            FspIoSlotVpd[] fspIoSlotVpdArray = this.mCecMgr.getCmdHelper().getIoSlotsVpdInfo(fspIoBus);
            Vector vector = rObject2.associators(R50Define.AID_IBMHSC_SlotInBus);
            RObject rObject3 = null;
            if (vector != null && !vector.isEmpty()) {
                for (n = 0; n < vector.size(); ++n) {
                    int n2;
                    rObject3 = (RObject)vector.elementAt(n);
                    String string = (String)rObject3.getProperty("DeviceID");
                    UnsignedInt32 unsignedInt32 = new UnsignedInt32(Long.parseLong(string));
                    System.out.println("++++++++ existing slot id: " + unsignedInt32);
                    String string2 = (String)rObject3.getProperty("DrcName");
                    int n3 = -1;
                    for (n2 = 0; n2 < fspIoSlotArray.length; ++n2) {
                        if (fspIoSlotArray[n2] == null || !fspIoSlotArray[n2].getDrcIndex().equals((Object)unsignedInt32)) continue;
                        n3 = n2;
                        break;
                    }
                    n2 = -1;
                    for (int i = 0; i < fspIoSlotVpdArray.length; ++i) {
                        if (!fspIoSlotVpdArray[i].getDrcIndex().equals((Object)unsignedInt32)) continue;
                        n2 = i;
                        break;
                    }
                    if (n3 == -1) {
                        System.out.println("++++++++ no such slot: " + unsignedInt32);
                        rObject3.deleteInstance();
                        Hashtable hashtable = this.mCecMgr.getPhyIODrcIndexTable();
                        Hashtable hashtable2 = this.mCecMgr.getPhyIODrcNameTable();
                        Hashtable hashtable3 = this.mCecMgr.getPhyIODrcIndexToFullLocTable();
                        hashtable.remove(string);
                        hashtable2.remove(string2);
                        hashtable3.remove(string);
                        continue;
                    }
                    this.rebuildSlotInst(rObject3, fspIoSlotArray[n3], n2 == -1 ? new FspIoSlotVpd() : fspIoSlotVpdArray[n2], rObject, rObject2);
                    fspIoSlotArray[n3] = null;
                }
            }
            for (n = 0; n < fspIoSlotArray.length; ++n) {
                if (fspIoSlotArray[n] == null) continue;
                int n4 = -1;
                for (int i = 0; i < fspIoSlotVpdArray.length; ++i) {
                    if (!fspIoSlotVpdArray[i].getDrcIndex().equals((Object)fspIoSlotArray[n].getDrcIndex())) continue;
                    n4 = i;
                    break;
                }
                this.createSlotInst(fspIoSlotArray[n], n4 == -1 ? new FspIoSlotVpd() : fspIoSlotVpdArray[n4], rObject, rObject2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
        }
    }

    public int getPartitionId(RObject rObject) throws RException {
        String string = (String)rObject.getProperty("Name");
        return OmUtils.getInstance().getLparIdByName(string);
    }

    public RObject getPartitionById(int n) throws RException {
        String string = OmUtils.getInstance().getLparName(n, this.mCecMgr.getCecName());
        RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_Partition);
        rObjectId.setKeyValue(0, string);
        rObjectId.setKeyValue(1, "IBMHSC_Partition");
        try {
            return rObjectId.getObject();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void rebuildAllocatedAsso(RObject rObject, int n) throws RException {
        RObject rObject2;
        Vector vector = rObject.associators(R50Define.AID_IBMHSC_AllocatedSlot);
        if (vector != null && vector.size() > 0) {
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                RObject rObject3 = (RObject)vector.elementAt(i);
                int n2 = this.getPartitionId(rObject3);
                if (n2 != n) {
                    rObject.deleteAssociation(R50Define.AID_IBMHSC_AllocatedSlot, rObject3.getObjectId());
                    continue;
                }
                bl = true;
            }
            if (bl) {
                return;
            }
        }
        if ((rObject2 = this.getPartitionById(n)) != null) {
            rObject.addAssociation(R50Define.AID_IBMHSC_AllocatedSlot, rObject2.getObjectId());
        }
    }

    public void rebuildSlotsCommon() throws RException, PIHscServerException {
        this.rebuildSlotsCommon(false);
    }

    public void rebuildSlotsCommon(boolean bl) throws RException, PIHscServerException {
        System.out.println("in rebuildSlotsCommon");
        Vector vector = this.mCecMgr.getObject().associators(R50Define.AID_IBMHSC_UsingIODrawer);
        System.out.println("drawerInsts = " + vector);
        if (vector == null || vector.size() <= 0) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            RObject rObject = (RObject)vector.elementAt(i);
            this.rebuildSlotsCommonForDrawer(rObject, bl);
        }
    }

    private void rebuildSlotsCommonForDrawer(RObject rObject, boolean bl) throws RException, PIHscServerException {
        Vector vector = rObject.associators(R50Define.AID_IBMHSC_IODrawerPCIBus);
        System.out.println("busInsts = " + vector);
        if (vector == null || vector.size() <= 0) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            RObject rObject2 = (RObject)vector.elementAt(i);
            this.rebuildSlotsCommonForBus(rObject2, bl);
        }
    }

    private void rebuildSlotsCommonForBus(RObject rObject, boolean bl) throws RException, PIHscServerException {
        int n;
        Vector vector = rObject.associators(R50Define.AID_IBMHSC_SlotInBus);
        if (vector == null || vector.size() <= 0) {
            return;
        }
        String string = (String)rObject.getProperty("DeviceID");
        int n2 = vector.size();
        FspIoSlotCommon[] fspIoSlotCommonArray = this.mCecMgr.getCmdHelper().getIoSlotsCommonInfo(string, n2);
        if (fspIoSlotCommonArray == null || fspIoSlotCommonArray.length == 0) {
            System.out.println("cannot get slot common info for bus " + string);
            return;
        }
        block0: for (n = 0; n < n2; ++n) {
            RObject rObject2 = (RObject)vector.elementAt(n);
            String string2 = (String)rObject2.getProperty("DeviceID");
            for (int i = 0; i < fspIoSlotCommonArray.length; ++i) {
                if (fspIoSlotCommonArray[i] != null && string2.equals(fspIoSlotCommonArray[i].getDrcIndex().toString())) {
                    if (!bl) {
                        this.rebuildSlotInstCommon(rObject2, fspIoSlotCommonArray[i]);
                    }
                    this.rebuildSlotAssociationsCommon(rObject2, fspIoSlotCommonArray[i], bl);
                    fspIoSlotCommonArray[i] = null;
                    continue block0;
                }
                if (i != fspIoSlotCommonArray.length - 1) continue;
                System.out.println("cannot find common info for slot with drcndx " + string2);
            }
        }
        for (n = 0; n < fspIoSlotCommonArray.length; ++n) {
            if (fspIoSlotCommonArray[n] == null) continue;
            System.out.println("cannot find slot inst for common info  with drcndx " + fspIoSlotCommonArray[n].getDrcIndex());
        }
    }

    private void rebuildSlotInstCommon(RObject rObject, FspIoSlotCommon fspIoSlotCommon) throws RException {
        if (rObject.setProperty("PriorityFlag", (Object)fspIoSlotCommon.getPriorityFlag())) {
            System.out.println("++++++++ PriorityFlag: " + fspIoSlotCommon.getPriorityFlag());
        }
        if (rObject.setProperty("CurLockOwnerClass", (Object)fspIoSlotCommon.getCurSlotLockOwnerClass())) {
            System.out.println("++++++++ CurLockOwnerClass: " + fspIoSlotCommon.getCurSlotLockOwnerClass());
        }
        if (rObject.setProperty("CurLockOwnerId", (Object)fspIoSlotCommon.getCurSlotLockOwnerId())) {
            System.out.println("++++++++ CurLockOwnerId: " + fspIoSlotCommon.getCurSlotLockOwnerId());
        }
        if (rObject.setProperty("PendLockOwnerClass", (Object)fspIoSlotCommon.getPendingSlotLockOwnerClass())) {
            System.out.println("++++++++ PendLockOwnerClass: " + fspIoSlotCommon.getPendingSlotLockOwnerClass());
        }
        if (rObject.setProperty("PendLockOwnerId", (Object)fspIoSlotCommon.getPendingSlotLockOwnerId())) {
            System.out.println("++++++++ PendLockOwnerId: " + fspIoSlotCommon.getPendingSlotLockOwnerId());
        }
    }

    private void rebuildSlotAssociationsCommon(RObject rObject, FspIoSlotCommon fspIoSlotCommon, boolean bl) throws RException {
        this.rebuildAllocatedAsso(rObject, fspIoSlotCommon.getAssignedPartitionId().intValue());
        if (!bl) {
            this.rebuildIoFailOverPool(rObject, fspIoSlotCommon.getIoPoolId());
        }
    }

    private void rebuildSlotAssociations(RObject rObject, RObject rObject2, FspIoSlot fspIoSlot, RObject rObject3) throws RException {
        this.rebuildSlotBusAsso(rObject, rObject3);
        this.rebuildSlotDrawerAsso(rObject, rObject2);
        if (OmIoResAct.isIop(fspIoSlot)) {
            this.rebuildIopGroup(rObject, rObject2, fspIoSlot.getDrcIndex().toString());
        } else if (fspIoSlot.getCandidateIopDrcIndex() != null && fspIoSlot.getCandidateIopDrcIndex().longValue() != 0L) {
            this.rebuildIopGroup(rObject, rObject2, fspIoSlot.getCandidateIopDrcIndex().toString());
        } else {
            rObject.deleteAssociations(R50Define.AID_IBMHSC_SlotInIOPGroup);
        }
    }

    private void rebuildSlotBusAsso(RObject rObject, RObject rObject2) throws RException {
        Vector vector = rObject.associators(R50Define.AID_IBMHSC_SlotInBus);
        String string = (String)rObject2.getProperty("DeviceID");
        if (vector != null && vector.size() > 0) {
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                RObject rObject3 = (RObject)vector.elementAt(i);
                String string2 = (String)rObject3.getProperty("DeviceID");
                if (!string.equals(string2)) {
                    rObject.deleteAssociation(R50Define.AID_IBMHSC_SlotInBus, rObject3.getObjectId());
                    continue;
                }
                bl = true;
            }
            if (bl) {
                return;
            }
        }
        System.out.println("add slot bus asso");
        rObject.addAssociation(R50Define.AID_IBMHSC_SlotInBus, rObject2.getObjectId());
    }

    private void rebuildSlotDrawerAsso(RObject rObject, RObject rObject2) throws RException {
        Vector vector = rObject.associators(R50Define.AID_IBMHSC_IODrawerSlot);
        String string = (String)rObject2.getProperty("Name");
        if (vector != null && vector.size() > 0) {
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                RObject rObject3 = (RObject)vector.elementAt(i);
                String string2 = (String)rObject3.getProperty("Name");
                if (!string2.equals(string)) {
                    rObject.deleteAssociation(R50Define.AID_IBMHSC_IODrawerSlot, rObject3.getObjectId());
                    continue;
                }
                bl = true;
            }
            if (bl) {
                return;
            }
        }
        System.out.println("add slot drawer asso");
        rObject.addAssociation(R50Define.AID_IBMHSC_IODrawerSlot, rObject2.getObjectId());
    }

    private static boolean isIop(FspIoSlot fspIoSlot) {
        return (fspIoSlot.getIopInfo().intValue() & 1) != 0;
    }

    private RObject getIopGroupById(String string, RObject rObject) throws RException {
        RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_IOPGroup);
        rObjectId.setKeyValue(1, "IBMHSC_IODrawer");
        rObjectId.setKeyValue(0, rObject.getProperty("Name"));
        rObjectId.setKeyValue(2, string);
        RObject rObject2 = null;
        try {
            rObject2 = rObjectId.getObject();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (rObject2 != null) {
            return rObject2;
        }
        rObject2 = new RObject(rObjectId);
        rObject2.addInstance();
        rObject2.addAssociation(R50Define.AID_IBMHSC_IODrawerIOPGroup, rObject.getObjectId());
        return rObject2;
    }

    private void clearEmptyIopGroup(RObject rObject) throws RException {
        Vector vector = rObject.associators(R50Define.AID_IBMHSC_IODrawerIOPGroup);
        if (vector == null || vector.size() < 1) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            RObject rObject2 = (RObject)vector.elementAt(i);
            Vector vector2 = rObject2.associators(R50Define.AID_IBMHSC_SlotInIOPGroup);
            if (vector2 != null && vector2.size() >= 1) continue;
            rObject2.deleteInstance();
        }
    }

    private void rebuildIopGroup(RObject rObject, RObject rObject2, String string) throws RException {
        Vector vector = rObject.associators(R50Define.AID_IBMHSC_SlotInIOPGroup);
        if (vector != null && vector.size() > 0) {
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                RObject rObject3 = (RObject)vector.elementAt(i);
                String string2 = (String)rObject3.getProperty("CollectionID");
                if (string2.equals(string)) {
                    bl = true;
                    continue;
                }
                rObject.deleteAssociations(R50Define.AID_IBMHSC_SlotInIOPGroup);
            }
            if (bl) {
                return;
            }
        }
        RObject rObject4 = this.getIopGroupById(string, rObject2);
        rObject.addAssociation(R50Define.AID_IBMHSC_SlotInIOPGroup, rObject4.getObjectId());
    }

    private void rebuildIoFailOverPool(RObject rObject, UnsignedInt16 unsignedInt16) throws RException {
        if (unsignedInt16.intValue() == 65535) {
            rObject.deleteAssociations(R50Define.AID_IBMHSC_SlotInIOFailOverPool);
            return;
        }
        Vector vector = rObject.associators(R50Define.AID_IBMHSC_SlotInIOFailOverPool);
        String string = String.valueOf(unsignedInt16);
        if (vector != null && vector.size() > 0) {
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                RObject rObject2 = (RObject)vector.elementAt(i);
                String string2 = (String)rObject2.getProperty("CollectionID");
                if (string2.equals(string)) {
                    bl = true;
                    continue;
                }
                rObject.deleteAssociation(R50Define.AID_IBMHSC_SlotInIOFailOverPool, rObject2.getObjectId());
            }
            if (bl) {
                return;
            }
        }
        RObject rObject3 = this.getFailedOverPoolById(string);
        rObject.addAssociation(R50Define.AID_IBMHSC_SlotInIOFailOverPool, rObject3.getObjectId());
    }

    private void clearEmptyFailedOverPool() throws RException {
        Vector vector = this.mCecMgr.getObject().associators(R50Define.AID_IBMHSC_CompSysIOFailOverPool);
        if (vector == null || vector.size() < 1) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            RObject rObject = (RObject)vector.elementAt(i);
            if (rObject.hasAssociation(R50Define.AID_IBMHSC_SlotInIOFailOverPool) || rObject.hasAssociation(R50Define.AID_IBMHSC_LparInIOFailOverPool)) continue;
            rObject.deleteInstance();
        }
    }

    private RObject getFailedOverPoolById(String string) throws RException {
        RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_IOFailOverPool);
        rObjectId.setKeyValue(0, this.mCecMgr.getCecName());
        rObjectId.setKeyValue(1, "IBMHSC_ComputerSystem");
        rObjectId.setKeyValue(2, string);
        RObject rObject = null;
        try {
            rObject = rObjectId.getObject();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (rObject != null) {
            return rObject;
        }
        rObject = new RObject(rObjectId);
        rObject.addInstance();
        rObject.addAssociation(R50Define.AID_IBMHSC_CompSysIOFailOverPool, this.mCecMgr.getObject().getObjectId());
        return rObject;
    }
}

